/*
* mhal_pinmux.c- Sigmastar
*
* Copyright (C) 2018 Sigmastar Technology Corp.
*
* Author: karl.xiao <karl.xiao@sigmastar.com.tw>
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
*/
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/kdev_t.h>
#include <linux/slab.h>
#include <linux/mm.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <linux/workqueue.h>
#include <linux/poll.h>
#include <linux/wait.h>
#include <linux/cdev.h>
#include <linux/time.h>
#include <linux/timer.h>
#include <asm/io.h>


//#include "mhal_gpio_reg.h"
//#include "mhal_gpio.h"
#include "ms_platform.h"
#include "mdrv_types.h"

#include "padmux.h"
#include "gpio.h"
#define CHIPTOP_BASE_ADDR 0x101E 
#define PMSLEEP_BASE_ADDR 0x000E
#define PM_SAR_BASE_ADDR  0x0014
#define ALBANY2_BASE_ADDR 0x0033
#define UTMI0_BASE_ADDR   0x1421
#define UTMI1_BASE_ADDR   0x1429




//16bit offset
//CHIPTOP
#define REG_FUART_MODE     0x03
#define REG_UART0_MODE     0x03
#define REG_UART1_MODE     0x03
#define REG_SR_MODE        0x06
#define REG_SR_I2C_MODE    0x06
#define REG_PWM0_MODE      0x07
#define REG_PWM1_MODE      0x07
#define REG_PWM2_MODE      0x07
#define REG_PWM3_MODE      0x07
#define REG_PWM4_MODE      0x07
#define REG_PWM5_MODE      0x07
#define REG_PWM6_MODE      0x07
#define REG_PWM7_MODE      0x07
#define REG_NAND_MODE      0x08
#define REG_SD_MODE        0x08
#define REG_SDIO_MODE      0x08
#define REG_I2C0_MODE      0x09
#define REG_I2C1_MODE      0x09
#define REG_SPI0_MODE      0x0c
#define REG_SPI1_MODE      0x0c
#define REG_EJ_MODE        0x0F
#define REG_ETH_MODE       0x0F
#define REG_CCIR_MODE      0x0F
#define REG_TTL_MODE       0x0F
#define REG_I2S_MODE       0x0F
#define REG_DMIC_MODE      0x0F
#define REG_TEST_IN_MODE   0x12
#define REG_TEST_OUT_MODE  0x12
#define REG_EMMC_MODE      0x13
#define REG_ALL_PAD_IN     0x50


//PMSLEEP
#define REG_GPIO_PM_LOCK    0x12
#define REG_IR_IS_GPIO      0x1c
#define REG_SD_CDZ_MODE     0x28
#define REG_PM_PWM0_MODE    0x28
#define REG_PM_PWM1_MODE    0x28
#define REG_PM_PWM2_MODE    0x28
#define REG_PM_PWM3_MODE    0x28
#define REG_LED_MODE        0x28
#define REG_SPI_IS_GPIO     0x35

//SAR
#define REG_SAR_MODE        0x11

//EMAC ALBANY2_BASE_ADDR
#define REG_ETH_GPIO_EN     0x71



typedef struct stPadmux
{
    U16 padID;
    U16 base;
    U16 offset;
    U16 mask;
    U16 val;
    U16 mode;
} ST_PADMUX;

ST_PADMUX padmux_table[]=
{
    {PAD_GPIO0, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT6,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode4 */
    {PAD_GPIO0, CHIPTOP_BASE_ADDR, REG_FUART_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_FUART_MODE}, /* FUART mode2 */
    {PAD_GPIO0, CHIPTOP_BASE_ADDR, REG_I2S_MODE,        BIT10,          BIT10,      PINMUX_FOR_I2S_MODE}, /* I2S mode1 */

    {PAD_GPIO1, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT6,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode4 */
    {PAD_GPIO1, CHIPTOP_BASE_ADDR, REG_FUART_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_FUART_MODE}, /* FUART mode2 */
    {PAD_GPIO1, CHIPTOP_BASE_ADDR, REG_I2S_MODE,        BIT10,          BIT10,      PINMUX_FOR_I2S_MODE}, /* I2S mode1 */

    {PAD_GPIO2, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT6,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode4 */
    {PAD_GPIO2, CHIPTOP_BASE_ADDR, REG_FUART_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_FUART_MODE}, /* FUART mode2 */
    {PAD_GPIO2, CHIPTOP_BASE_ADDR, REG_I2S_MODE,        BIT10,          BIT10,      PINMUX_FOR_I2S_MODE}, /* I2S mode1 */

    {PAD_GPIO3, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT6,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode4 */
    {PAD_GPIO3, CHIPTOP_BASE_ADDR, REG_FUART_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_FUART_MODE}, /* FUART mode2 */
    {PAD_GPIO3, CHIPTOP_BASE_ADDR, REG_I2S_MODE,        BIT10,          BIT10,      PINMUX_FOR_I2S_MODE}, /* I2S mode1 */

    {PAD_GPIO4, CHIPTOP_BASE_ADDR, REG_UART0_MODE,      BIT5|BIT4,      BIT5|BIT4,  PINMUX_FOR_UART0_MODE}, /* UART0 mode3 */
    {PAD_GPIO4, CHIPTOP_BASE_ADDR, REG_DMIC_MODE,       BIT8,           BIT8,       PINMUX_FOR_DMIC_MODE}, /* DMIC mode */

    {PAD_GPIO5, CHIPTOP_BASE_ADDR, REG_UART0_MODE,      BIT5|BIT4,      BIT5|BIT4,  PINMUX_FOR_UART0_MODE}, /* UART0 mode3 */
    {PAD_GPIO5, CHIPTOP_BASE_ADDR, REG_DMIC_MODE,       BIT8,           BIT8,       PINMUX_FOR_DMIC_MODE}, /* DMIC mode */

    {PAD_GPIO6, CHIPTOP_BASE_ADDR, REG_UART1_MODE,      BIT9|BIT8,      BIT9|BIT8,  PINMUX_FOR_UART1_MODE}, /* UART1 mode3 */
    {PAD_GPIO6, CHIPTOP_BASE_ADDR, REG_DMIC_MODE,       BIT8,           BIT8,       PINMUX_FOR_DMIC_MODE}, /* DMIC mode */

    {PAD_GPIO7, CHIPTOP_BASE_ADDR, REG_UART1_MODE,      BIT9|BIT8,      BIT9|BIT8,  PINMUX_FOR_UART1_MODE}, /* UART1 mode3 */
    {PAD_GPIO7, CHIPTOP_BASE_ADDR, REG_ETH_MODE,        BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO8, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode2 */
    {PAD_GPIO8, CHIPTOP_BASE_ADDR, REG_ETH_MODE,        BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO9, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode2 */
    {PAD_GPIO9, CHIPTOP_BASE_ADDR, REG_ETH_MODE,        BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO10, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode2 */
    {PAD_GPIO10, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO11, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode2 */
    {PAD_GPIO11, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO12, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,      BIT6|BIT5|BIT4, BIT5,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode2 */
    {PAD_GPIO12, CHIPTOP_BASE_ADDR, REG_PWM0_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_PWM0_MODE}, /* PWM0 mode2 */
    {PAD_GPIO12, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO13, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,      BIT6|BIT5|BIT4, BIT5,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode2 */
    {PAD_GPIO13, CHIPTOP_BASE_ADDR, REG_PWM1_MODE,      BIT3|BIT2,      BIT3,       PINMUX_FOR_PWM1_MODE}, /* PWM1 mode2 */
    {PAD_GPIO13, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO14, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,      BIT6|BIT5|BIT4, BIT5,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode2 */
    {PAD_GPIO14, CHIPTOP_BASE_ADDR, REG_PWM2_MODE,      BIT5|BIT4,      BIT4,       PINMUX_FOR_PWM2_MODE}, /* PWM2 mode1 */
    {PAD_GPIO14, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_GPIO15, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,      BIT6|BIT5|BIT4, BIT5,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode2 */
    {PAD_GPIO15, CHIPTOP_BASE_ADDR, REG_PWM3_MODE,      BIT7|BIT6,      BIT6,       PINMUX_FOR_PWM3_MODE}, /* PWM3 mode1 */
    {PAD_GPIO15, CHIPTOP_BASE_ADDR, REG_ETH_MODE,       BIT2,           BIT2,       PINMUX_FOR_ETH_MODE}, /* ETH mode */

    {PAD_FUART_RX, CHIPTOP_BASE_ADDR, REG_EJ_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE},
    {PAD_FUART_RX, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,    BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_SPI0_MODE}, /* SPI0 mode3 */
    {PAD_FUART_RX, CHIPTOP_BASE_ADDR, REG_FUART_MODE,   BIT1|BIT0,      BIT0,       PINMUX_FOR_FUART_MODE}, /* FUART mode1 */
    {PAD_FUART_RX, CHIPTOP_BASE_ADDR, REG_UART0_MODE,   BIT5|BIT4,      BIT5,       PINMUX_FOR_UART0_MODE}, /* UART0 mode2 */
    {PAD_FUART_RX, CHIPTOP_BASE_ADDR, REG_PWM0_MODE,    BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_PWM0_MODE}, /* PWM0 mode3 */

    {PAD_FUART_TX, CHIPTOP_BASE_ADDR, REG_EJ_MODE,      BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE},
    {PAD_FUART_TX, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,    BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_SPI0_MODE}, /* SPI0 mode3 */
    {PAD_FUART_TX, CHIPTOP_BASE_ADDR, REG_FUART_MODE,   BIT1|BIT0,      BIT0,       PINMUX_FOR_FUART_MODE}, /* FUART mode1 */
    {PAD_FUART_TX, CHIPTOP_BASE_ADDR, REG_UART0_MODE,   BIT5|BIT4,      BIT5,       PINMUX_FOR_UART0_MODE}, /* UART0 mode2 */
    {PAD_FUART_TX, CHIPTOP_BASE_ADDR, REG_PWM1_MODE,    BIT3|BIT2,      BIT3|BIT2,  PINMUX_FOR_PWM1_MODE}, /* PWM1 mode3 */

    {PAD_FUART_CTS, CHIPTOP_BASE_ADDR, REG_EJ_MODE,     BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE},
    {PAD_FUART_CTS, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,   BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_SPI0_MODE}, /* SPI0 mode3 */
    {PAD_FUART_CTS, CHIPTOP_BASE_ADDR, REG_FUART_MODE,  BIT1|BIT0,      BIT0,       PINMUX_FOR_FUART_MODE}, /* FUART mode1 */
    {PAD_FUART_CTS, CHIPTOP_BASE_ADDR, REG_UART1_MODE,  BIT9|BIT8,      BIT9,       PINMUX_FOR_UART1_MODE}, /* UART1 mode2 */
    {PAD_FUART_CTS, CHIPTOP_BASE_ADDR, REG_PWM2_MODE,   BIT5|BIT4,      BIT5,       PINMUX_FOR_PWM2_MODE}, /* PWM2 mode2 */

    {PAD_FUART_RTS, CHIPTOP_BASE_ADDR, REG_EJ_MODE,     BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE},
    {PAD_FUART_RTS, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,   BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_SPI0_MODE}, /* SPI0 mode3 */
    {PAD_FUART_RTS, CHIPTOP_BASE_ADDR, REG_FUART_MODE,  BIT1|BIT0,      BIT0,       PINMUX_FOR_FUART_MODE}, /* FUART mode1 */
    {PAD_FUART_RTS, CHIPTOP_BASE_ADDR, REG_UART1_MODE,  BIT9|BIT8,      BIT9,       PINMUX_FOR_UART1_MODE}, /* UART1 mode2 */
    {PAD_FUART_RTS, CHIPTOP_BASE_ADDR, REG_PWM3_MODE,   BIT7|BIT6,      BIT7,       PINMUX_FOR_PWM3_MODE}, /* PWM3 mode2 */

    {PAD_I2C0_SCL, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,    BIT1|BIT0,      BIT0,       PINMUX_FOR_I2C0_MODE}, /* I2C0 mode1 */
    {PAD_I2C0_SCL, CHIPTOP_BASE_ADDR, REG_SR_I2C_MODE,  BIT5|BIT4,      BIT4,       PINMUX_FOR_SR_MODE}, /* SR mode1 */

    {PAD_I2C0_SDA, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,    BIT1|BIT0,      BIT0,       PINMUX_FOR_I2C0_MODE}, /* I2C0 mode1 */
    {PAD_I2C0_SDA, CHIPTOP_BASE_ADDR, REG_SR_I2C_MODE,  BIT5|BIT4,      BIT4,       PINMUX_FOR_SR_MODE}, /* SR mode1 */

    {PAD_I2C1_SCL, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,    BIT5|BIT4,      BIT4,       PINMUX_FOR_I2C1_MODE}, /* I2C1 mode1 */
    {PAD_I2C1_SCL, CHIPTOP_BASE_ADDR, REG_SR_I2C_MODE,  BIT5|BIT4,      BIT5,       PINMUX_FOR_SR_MODE}, /* SR mode2 */

    {PAD_I2C1_SDA, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,    BIT5|BIT4,      BIT4,       PINMUX_FOR_I2C1_MODE}, /* I2C1 mode1 */
    {PAD_I2C1_SDA, CHIPTOP_BASE_ADDR, REG_SR_I2C_MODE,  BIT5|BIT4,      BIT5,       PINMUX_FOR_SR_MODE}, /* SR mode2 */

    {PAD_SR_IO00, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,     BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_I2C0_MODE}, /* I2C0 mode3 */
    {PAD_SR_IO00, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,     BIT5|BIT4,      BIT5|BIT4,  PINMUX_FOR_I2C1_MODE}, /* I2C1 mode3 */
    {PAD_SR_IO00, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO00, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO00, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO01, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,     BIT1|BIT0,      BIT1|BIT0,  PINMUX_FOR_I2C0_MODE}, /* I2C0 mode3 */
    {PAD_SR_IO01, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,     BIT5|BIT4,      BIT5|BIT4,  PINMUX_FOR_I2C1_MODE}, /* I2C1 mode3 */
    {PAD_SR_IO01, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO01, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO01, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO02, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO03, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO04, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO05, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO06, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO07, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO08, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO09, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO10, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO11, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */
    {PAD_SR_IO12, CHIPTOP_BASE_ADDR, REG_CCIR_MODE,     BIT4,           BIT4,       PINMUX_FOR_CCIR_MODE}, /* CCIR mode */

    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO13, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO14, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2,       PINMUX_FOR_SR_MODE}, /* SR mode4 */
    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO15, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO16, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO16, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO16, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO16, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO16, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_SR_IO17, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT0,       PINMUX_FOR_SR_MODE}, /* SR mode1 */
    {PAD_SR_IO17, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1,       PINMUX_FOR_SR_MODE}, /* SR mode2 */
    {PAD_SR_IO17, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT1|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode3 */
    {PAD_SR_IO17, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT0,  PINMUX_FOR_SR_MODE}, /* SR mode5 */
    {PAD_SR_IO17, CHIPTOP_BASE_ADDR, REG_SR_MODE,       BIT2|BIT1|BIT0, BIT2|BIT1,  PINMUX_FOR_SR_MODE}, /* SR mode6 */

    {PAD_NAND_ALE, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_ALE, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_CLE, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_CLE, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_CLE, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_CLE, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_CEZ, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_CEZ, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_CEZ, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_CEZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_WEZ, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_WEZ, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_WEZ, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_WEZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_WPZ, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_WPZ, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_WPZ, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_WPZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_REZ, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_REZ, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_REZ, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_REZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_RBZ, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_RBZ, CHIPTOP_BASE_ADDR, REG_SD_MODE,      BIT3|BIT2,      BIT2,   PINMUX_FOR_SD_MODE}, /* SD mode1 */
    {PAD_NAND_RBZ, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_RBZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_DA0, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA0, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT1,           BIT1,   PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_DA0, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE},  /* TTL mode1 */

    {PAD_NAND_DA1, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,   PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA1, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,   PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA2, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA2, CHIPTOP_BASE_ADDR, REG_PWM2_MODE,    BIT5|BIT4,      BIT5|BIT4,  PINMUX_FOR_PWM2_MODE}, /* PWM2 mode3 */
    {PAD_NAND_DA2, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA3, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA3, CHIPTOP_BASE_ADDR, REG_PWM3_MODE,    BIT7|BIT6,      BIT7|BIT6,  PINMUX_FOR_PWM3_MODE}, /* PWM3 mode3 */
    {PAD_NAND_DA3, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA4, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA4, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,       PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_DA4, CHIPTOP_BASE_ADDR, REG_PWM4_MODE,    BIT9|BIT8,      BIT8,       PINMUX_FOR_PWM4_MODE}, /* PWM4 mode1 */
    {PAD_NAND_DA4, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA5, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA5, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,       PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_DA5, CHIPTOP_BASE_ADDR, REG_PWM5_MODE,    BIT11|BIT10,    BIT10,       PINMUX_FOR_PWM5_MODE}, /* PWM5 mode1 */
    {PAD_NAND_DA5, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA6, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA6, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,       PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_DA6, CHIPTOP_BASE_ADDR, REG_PWM6_MODE,    BIT13|BIT12,    BIT12,      PINMUX_FOR_PWM6_MODE}, /* PWM6 mode1 */
    {PAD_NAND_DA6, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_NAND_DA7, CHIPTOP_BASE_ADDR, REG_NAND_MODE,    BIT0,           BIT0,       PINMUX_FOR_NAND_MODE}, /* Nand mode1 */
    {PAD_NAND_DA7, CHIPTOP_BASE_ADDR, REG_EMMC_MODE,    BIT0,           BIT0,       PINMUX_FOR_EMMC_MODE},  /* EMMC mode1 */
    {PAD_NAND_DA7, CHIPTOP_BASE_ADDR, REG_PWM7_MODE,    BIT15|BIT14,    BIT14,      PINMUX_FOR_PWM7_MODE}, /* PWM7 mode1 */
    {PAD_NAND_DA7, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_UART0_RX, CHIPTOP_BASE_ADDR, REG_UART0_MODE,   BIT5|BIT4,      BIT4,       PINMUX_FOR_UART0_MODE}, /* UART0 mode1 */
    {PAD_UART0_RX, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_UART0_TX, CHIPTOP_BASE_ADDR, REG_UART0_MODE,   BIT5|BIT4,      BIT4,       PINMUX_FOR_UART0_MODE}, /* UART0 mode1 */
    {PAD_UART0_TX, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_UART1_RX, CHIPTOP_BASE_ADDR, REG_UART1_MODE,   BIT9|BIT8,      BIT8,       PINMUX_FOR_UART1_MODE},/* UART1 mode1 */
    {PAD_UART1_RX, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_UART1_TX, CHIPTOP_BASE_ADDR, REG_UART1_MODE,   BIT9|BIT8,      BIT8,       PINMUX_FOR_UART1_MODE},/* UART1 mode1 */
    {PAD_UART1_TX, CHIPTOP_BASE_ADDR, REG_TTL_MODE,     BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI0_CZ, CHIPTOP_BASE_ADDR, REG_EJ_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE}, /* EJ mode2 */
    {PAD_SPI0_CZ, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,     BIT1|BIT0,      BIT0,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode1 */
    {PAD_SPI0_CZ, CHIPTOP_BASE_ADDR, REG_PWM4_MODE,     BIT9|BIT8,      BIT9,       PINMUX_FOR_PWM4_MODE}, /* PWM4 mode2 */
    {PAD_SPI0_CZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI0_CK, CHIPTOP_BASE_ADDR, REG_EJ_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE}, /* EJ mode2 */
    {PAD_SPI0_CK, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,     BIT1|BIT0,      BIT0,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode1 */
    {PAD_SPI0_CK, CHIPTOP_BASE_ADDR, REG_PWM5_MODE,     BIT11|BIT10,    BIT11,      PINMUX_FOR_PWM5_MODE}, /* PWM5 mode2 */
    {PAD_SPI0_CK, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI0_DI, CHIPTOP_BASE_ADDR, REG_EJ_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE}, /* EJ mode2 */
    {PAD_SPI0_DI, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,     BIT1|BIT0,      BIT0,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode1 */
    {PAD_SPI0_DI, CHIPTOP_BASE_ADDR, REG_PWM6_MODE,     BIT13|BIT12,    BIT13,      PINMUX_FOR_PWM6_MODE}, /* PWM6 mode2 */
    {PAD_SPI0_DI, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI0_DO, CHIPTOP_BASE_ADDR, REG_EJ_MODE,       BIT1|BIT0,      BIT1,       PINMUX_FOR_EJ_MODE}, /* EJ mode2 */
    {PAD_SPI0_DO, CHIPTOP_BASE_ADDR, REG_SPI0_MODE,     BIT1|BIT0,      BIT0,       PINMUX_FOR_SPI0_MODE}, /* SPI0 mode1 */
    {PAD_SPI0_DO, CHIPTOP_BASE_ADDR, REG_PWM7_MODE,     BIT15|BIT14,    BIT15,      PINMUX_FOR_PWM7_MODE}, /* PWM7 mode2 */
    {PAD_SPI0_DO, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI1_CZ, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,     BIT6|BIT5|BIT4, BIT4,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode1 */
    {PAD_SPI1_CZ, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI1_CK, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,     BIT6|BIT5|BIT4, BIT4,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode1 */
    {PAD_SPI1_CK, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI1_DI, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,     BIT6|BIT5|BIT4, BIT4,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode1 */
    {PAD_SPI1_DI, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_SPI1_DO, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,     BIT6|BIT5|BIT4, BIT4,       PINMUX_FOR_SPI1_MODE}, /* SPI1 mode1 */
    {PAD_SPI1_DO, CHIPTOP_BASE_ADDR, REG_TTL_MODE,      BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_PWM0, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,        BIT1|BIT0,      BIT1,       PINMUX_FOR_I2C0_MODE}, /* I2C0 mode2 */
    {PAD_PWM0, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,        BIT5|BIT4,      BIT5,       PINMUX_FOR_I2C1_MODE}, /* I2C1 mode2 */
    {PAD_PWM0, CHIPTOP_BASE_ADDR, REG_PWM0_MODE,        BIT1|BIT0,      BIT0,       PINMUX_FOR_PWM0_MODE}, /* PWM0 mode1 */
    {PAD_PWM0, CHIPTOP_BASE_ADDR, REG_TTL_MODE,         BIT6,           BIT6,       PINMUX_FOR_TTL_MODE}, /* TTL mode1 */

    {PAD_PWM1, CHIPTOP_BASE_ADDR, REG_I2C0_MODE,        BIT1|BIT0,      BIT1,       PINMUX_FOR_I2C0_MODE}, /* I2C0 mode2 */
    {PAD_PWM1, CHIPTOP_BASE_ADDR, REG_I2C1_MODE,        BIT5|BIT4,      BIT5,       PINMUX_FOR_I2C1_MODE}, /* I2C1 mode2 */
    {PAD_PWM1, CHIPTOP_BASE_ADDR, REG_PWM1_MODE,        BIT3|BIT2,      BIT2,       PINMUX_FOR_PWM1_MODE}, /* PWM1 mode1 */

    {PAD_SD_CLK, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,      BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_CLK, CHIPTOP_BASE_ADDR, REG_SD_MODE,        BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_SD_CMD, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,      BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_CMD, CHIPTOP_BASE_ADDR, REG_SD_MODE,        BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_SD_D0, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT5|BIT4,  PINMUX_FOR_SPI1_MODE}, /* SPI1 mode3 */
    {PAD_SD_D0, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,       BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_D0, CHIPTOP_BASE_ADDR, REG_SD_MODE,         BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_SD_D1, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT5|BIT4,  PINMUX_FOR_SPI1_MODE}, /* SPI1 mode3 */
    {PAD_SD_D1, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,       BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_D1, CHIPTOP_BASE_ADDR, REG_SD_MODE,         BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_SD_D2, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT5|BIT4,  PINMUX_FOR_SPI1_MODE}, /* SPI1 mode3 */
    {PAD_SD_D2, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,       BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_D2, CHIPTOP_BASE_ADDR, REG_SD_MODE,         BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_SD_D3, CHIPTOP_BASE_ADDR, REG_SPI1_MODE,       BIT6|BIT5|BIT4, BIT5|BIT4,  PINMUX_FOR_SPI1_MODE}, /* SPI1 mode3 */
    {PAD_SD_D3, CHIPTOP_BASE_ADDR, REG_SDIO_MODE,       BIT8,           BIT8,       PINMUX_FOR_SDIO_MODE}, /* SDIO mode1 */
    {PAD_SD_D3, CHIPTOP_BASE_ADDR, REG_SD_MODE,         BIT3|BIT2,      BIT3,       PINMUX_FOR_SD_MODE}, /* SD mode2 */

    {PAD_PM_SD_CDZ, PMSLEEP_BASE_ADDR, REG_SD_CDZ_MODE, BIT14,          BIT14,      PINMUX_FOR_SD_MODE},

    /* PAD_PM_IRIN special case*/

    {PAD_PM_GPIO0, PMSLEEP_BASE_ADDR, REG_PM_PWM0_MODE, BIT1|BIT0,      BIT0,       PINMUX_FOR_PWM0_MODE},

    {PAD_PM_GPIO1, PMSLEEP_BASE_ADDR, REG_PM_PWM1_MODE, BIT3|BIT2,      BIT2,       PINMUX_FOR_PWM1_MODE},

    {PAD_PM_GPIO2, PMSLEEP_BASE_ADDR, REG_PM_PWM2_MODE, BIT7|BIT6,      BIT6,       PINMUX_FOR_PWM2_MODE},

    {PAD_PM_GPIO3, PMSLEEP_BASE_ADDR, REG_PM_PWM3_MODE, BIT9|BIT8,      BIT8,       PINMUX_FOR_PWM3_MODE},

    /* PAD_PM_GPIO4 special case */

    {PAD_PM_GPIO5, PMSLEEP_BASE_ADDR, REG_PM_PWM1_MODE, BIT3|BIT2,      BIT3,       PINMUX_FOR_PWM1_MODE},

    {PAD_PM_GPIO6, PMSLEEP_BASE_ADDR, REG_PM_PWM0_MODE, BIT1|BIT0,      BIT1,       PINMUX_FOR_PWM0_MODE},

    /* PM_GPIO7 - only config as GPIO mode */

    {PAD_PM_GPIO8, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO,  BIT3|BIT2,      BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_GPIO9, PMSLEEP_BASE_ADDR, REG_PM_PWM2_MODE, BIT7|BIT6,      BIT7,       PINMUX_FOR_PWM2_MODE},

    {PAD_PM_GPIO10, PMSLEEP_BASE_ADDR, REG_PM_PWM3_MODE,BIT9|BIT8,      BIT9,       PINMUX_FOR_PWM3_MODE},

    {PAD_PM_SPI_CZ, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO, BIT3,           BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_SPI_CK, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO, BIT3,           BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_SPI_DI, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO, BIT3,           BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_SPI_DO, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO, BIT3,           BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_SPI_WPZ, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO,BIT3,           BIT3,       PINMUX_FOR_PMSPI_MODE},

    {PAD_PM_SPI_HLD, PMSLEEP_BASE_ADDR, REG_SPI_IS_GPIO,BIT7|BIT6,      BIT6,       PINMUX_FOR_SPI1_MODE},

    {PAD_PM_LED0, PMSLEEP_BASE_ADDR, REG_LED_MODE,      BIT5|BIT4,      BIT4,       PINMUX_FOR_LED_MODE},

    {PAD_PM_LED1, PMSLEEP_BASE_ADDR, REG_LED_MODE,      BIT5|BIT4,      BIT4,       PINMUX_FOR_LED_MODE},

    {PAD_SAR_GPIO0, PM_SAR_BASE_ADDR, REG_SAR_MODE,     BIT0,           BIT0,       PINMUX_FOR_SAR_MODE},

    {PAD_SAR_GPIO1, PM_SAR_BASE_ADDR, REG_SAR_MODE,     BIT1,           BIT1,       PINMUX_FOR_SAR_MODE},

    {PAD_SAR_GPIO2, PM_SAR_BASE_ADDR, REG_SAR_MODE,     BIT2,           BIT2,       PINMUX_FOR_SAR_MODE},

    {PAD_SAR_GPIO3, PM_SAR_BASE_ADDR, REG_SAR_MODE,     BIT3,           BIT3,       PINMUX_FOR_SAR_MODE},

    {PAD_ETH_RN, ALBANY2_BASE_ADDR, REG_ETH_GPIO_EN,    BIT0,           BIT0,       PINMUX_FOR_ETH_MODE},

    {PAD_ETH_RP, ALBANY2_BASE_ADDR, REG_ETH_GPIO_EN,    BIT1,           BIT1,       PINMUX_FOR_ETH_MODE},

    {PAD_ETH_TN, ALBANY2_BASE_ADDR, REG_ETH_GPIO_EN,    BIT2,           BIT2,       PINMUX_FOR_ETH_MODE},

    {PAD_ETH_TP, ALBANY2_BASE_ADDR, REG_ETH_GPIO_EN,    BIT3,           BIT3,       PINMUX_FOR_ETH_MODE},
};


S32 halCheckPin(U32 padID)
{
    if (GPIO_NR <= padID)
        return FALSE;

    return TRUE;
}

S32 halPadGetVal(U32 padID, U32* mode)
{
    U8 i = 0;
    U8 fgModeIsFind = 0;

    if (FALSE == halCheckPin(padID))
    {
        return FALSE;
    }

    *mode = PINMUX_FOR_GPIO_MODE;

    switch(padID)
    {
    case PAD_PM_GPIO4:
        if( INREG16((PMSLEEP_BASE_ADDR*0x200) + (REG_GPIO_PM_LOCK*0x4)) == 0xBABE )
        {
            return TRUE;
        }
        else
        {
            *mode = PINMUX_FOR_UNKNOWN_MODE;
            return FALSE;
        }

    case PAD_PM_GPIO7:
        return TRUE;

    case PAD_PM_SPI_CZ:
        *mode = PINMUX_FOR_UNKNOWN_MODE;
        return FALSE;

    case PAD_PM_IRIN:
        if( INREG16((PMSLEEP_BASE_ADDR*0x200) + (REG_IR_IS_GPIO*0x4))&BIT4 )
        {
            *mode = PINMUX_FOR_GPIO_MODE;
        }
        else
        {
            *mode = PINMUX_FOR_IRIN_MODE;
        }
        return TRUE;

    default:
        for(i=0; i<sizeof(padmux_table)/sizeof(struct stPadmux); i++)
        {
            if(padmux_table[i].padID == padID )
            {
                if( (INREG16( ((padmux_table[i].base)*0x200) + ((padmux_table[i].offset)*0x4))&(padmux_table[i].mask)) == padmux_table[i].val )
                {
                    *mode =  padmux_table[i].mode;
                    fgModeIsFind = 1;
                    break;
                }

            }
        }
    }


    if(!fgModeIsFind)
    {
        return FALSE;
    }

    return TRUE;
}


S32 halPadSetVal(U32 padID, U32 mode)
{
    U16 U16Reg_val = -1;
    U8 fgModeIsFind = 0;
	U16 i;

    if (FALSE == halCheckPin(padID))
    {
        return FALSE;
    }

    switch(padID)
    {

    case PAD_PM_GPIO4:
        if(mode == PINMUX_FOR_GPIO_MODE)
        {
            OUTREG16( PMSLEEP_BASE_ADDR*0x200 + REG_GPIO_PM_LOCK*4, 0xBABE);
        }
        return TRUE;

    case PAD_PM_GPIO7:
    case PAD_PM_SPI_CZ:
        return TRUE;

    case PAD_PM_IRIN:
        if(mode == PINMUX_FOR_GPIO_MODE)
        {
            U16Reg_val = INREG16( PMSLEEP_BASE_ADDR*0x200 + REG_IR_IS_GPIO*4 );
            U16Reg_val |= BIT4;
            OUTREG16( PMSLEEP_BASE_ADDR*0x200 + REG_IR_IS_GPIO*4, U16Reg_val);
        }
        return TRUE;

	case PAD_USB_DM:
	case PAD_USB_DP:
		if(mode == PINMUX_FOR_GPIO_MODE)
		{
		/*	reg_gpio_en=1;	(0x1421h1F#[14])
			reg_clk_extra_0_en=0; (0x1421h4#[7])
			reg_force_pll_on=0; 0x1421h4[14]
			reg_pdn_override=1; 0x1421h0[0]
			reg_reg_pdn=0; (0x1421h0#[15])
			reg_fl_xcvr_pdn=0;	(0x1421h0#[12])"      */
			SETREG16( UTMI0_BASE_ADDR*0x200 + 0x1F*4, BIT14);
			CLRREG16( UTMI0_BASE_ADDR*0x200 + 0x04*4, BIT7|BIT14);
			SETREG16( UTMI0_BASE_ADDR*0x200 + 0x00*4, BIT0);
			CLRREG16( UTMI0_BASE_ADDR*0x200 + 0x00*4, BIT15|BIT12);
		}
		return TRUE;

	case PAD_DM_P1:
	case PAD_DP_P1:
		if(mode == PINMUX_FOR_GPIO_MODE)
		{
		/*	reg_gpio_en=1;	(0x1429h1F#[14])
			reg_clk_extra_0_en=0; (0x1429h4#[7])
			reg_force_pll_on=0; 0x1429h4[14]
			reg_pdn_override=1; 0x1429h0[0]
			reg_reg_pdn=0; (0x1429h0#[15])
			reg_fl_xcvr_pdn=0;	(0x1429h0#[12])" 	*/		
			SETREG16( UTMI1_BASE_ADDR*0x200 + 0x1F*4, BIT14);
			CLRREG16( UTMI1_BASE_ADDR*0x200 + 0x04*4, BIT7|BIT14);
			SETREG16( UTMI1_BASE_ADDR*0x200 + 0x00*4, BIT0);
			CLRREG16( UTMI1_BASE_ADDR*0x200 + 0x00*4, BIT15|BIT12);

		}
		return TRUE;

    default:
        for(i=0; i<sizeof(padmux_table)/sizeof(struct stPadmux); i++)
        {
            if(padID == padmux_table[i].padID)
            {
                if(mode == padmux_table[i].mode)
                {
                    U16Reg_val = INREG16( (padmux_table[i].base)*0x200 + (padmux_table[i].offset)*0x4 );
                    U16Reg_val &= ~(padmux_table[i].mask);
                    U16Reg_val |= padmux_table[i].val;

                    OUTREG16( (padmux_table[i].base)*0x200 + (padmux_table[padID+i].offset)*4, U16Reg_val);
                    fgModeIsFind = 1;

                    break;
                }
                else
                {
                    //Clear high priority setting
                    U16Reg_val = INREG16( (padmux_table[i].base)*0x200 + (padmux_table[i].offset)*0x4 );
                    if((U16Reg_val&padmux_table[i].mask) == padmux_table[i].val)
                    {
                        U16Reg_val &= (~padmux_table[i].mask);
                        OUTREG16( (padmux_table[i].base)*0x200 + (padmux_table[i].offset)*0x4, U16Reg_val);
                    }
                }
            }
        }
    }
    if(!fgModeIsFind)
    {
        return FALSE;
    }
    return TRUE;
}



